;coded by UEZ build 2015-08-20
#include <Array.au3>
#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("GUIOnEventMode", 1)

_GDIPlus_Startup()
Global $i
Global Const $iW = 600, $iH = 700, $sTitle = "GDI+ Smoke Sim / fps: "
Global Const $hGUI = GUICreate($sTitle & 0, $iW, $iH)
GUISetState()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, 4)

Global Const $iParticles = 60, $hBitmap_Pipe = _GDIPlus_BitmapCreateFromMemory(_Pipe())

;6/10 (60%), 3/10 (30%), 1/10 (10%)
Global  $aSmoke[10] = [ _GDIPlus_BitmapCreateFromMemory(_Smoke()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke2()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke2()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke2()), _
						_GDIPlus_BitmapCreateFromMemory(_Smoke3())]

_ArrayShuffle($aSmoke)
Global $aData[$iParticles][6] = [[]], $iFPS = 0

For $i = 0 To UBound($aData) - 1
	$aData[$i][0] = 3.5 ;size
	$aData[$i][1] = $iW - 300 + Random(-20, 20);x
	$aData[$i][2] = $iH - 140 + Random(0, $iH * 0.25) ;y
	$aData[$i][3] = Random(-0.5, 0.5) ;vx
	$aData[$i][4] = 1 ;vy
	$aData[$i][5] = Random(0, UBound($aSmoke) - 1, 1)
Next

Global Const $hAttribute_Alpha = _GDIPlus_ImageAttributesCreate()

AdlibRegister("CalcFPS", 1000)

GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")

Anim()
While Sleep(30)
	Anim()
WEnd

Func _Exit()
	AdlibUnRegister("CalcFPS")
	_GDIPlus_ImageAttributesDispose($hAttribute_Alpha)
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC_backbuffer, $DC_obj)
	_WinAPI_DeleteDC($hDC_backbuffer)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_BitmapDispose($hBitmap_Pipe)
	For $i = 0 To UBound($aSmoke) - 1
		_GDIPlus_BitmapDispose($aSmoke[$i])
	Next
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc

Func Anim()
	Local $i, $fSize, $fTransparency, $hBmp
	_GDIPlus_GraphicsClear($hCanvas, 0xB0ABCDEF)
	_GDIPlus_GraphicsDrawImageRect($hCanvas, $hBitmap_Pipe, $iW - 356, $iH - 286, 266, 286)
	For $i = 0 To UBound($aData) - 1
		$fSize = $aData[$i][0] * $aData[$i][4] * 4
		If $aData[$i][2] < $iH - 135 Then
			$fTransparency = -2 + $aData[$i][4]
			If $fTransparency < 0 Then
				$hBmp = _GDIPlus_BitmapCloneArea($aSmoke[$aData[$i][5]], 0, 0, 70, 70, $GDIP_PXF32ARGB)
				$tColorMatrix = _GDIPlus_ColorMatrixCreateTranslate(0, 0, 0, $fTransparency)
				$pColorMatrix = DllStructGetPtr($tColorMatrix)
				_GDIPlus_ImageAttributesSetColorMatrix($hAttribute_Alpha, 0, True, $pColorMatrix)
				_GDIPlus_GraphicsDrawImageRectRect($hCanvas, $hBmp, 0, 0, 70, 70, _
																	$aData[$i][1] - 6 * $aData[$i][4], $aData[$i][2], _
																	$fSize, $fSize, $hAttribute_Alpha)
				_GDIPlus_BitmapDispose($hBmp)
			Else
				_GDIPlus_GraphicsDrawImageRectRect($hCanvas, $aSmoke[$aData[$i][5]], 0, 0, 70, 70, _
															 $aData[$i][1] - 6 * $aData[$i][4], _
															 $aData[$i][2], _
															 $fSize, $fSize)
			EndIf
			$aData[$i][4] *= 1.0275
			$aData[$i][1] += $aData[$i][3]
		EndIf
		$aData[$i][2] -= $aData[$i][4]
		If $aData[$i][2] < -$fSize Then
			$aData[$i][0] = 3.5 ;size
			$aData[$i][1] = $iW - 300 + Random(-20, 20);x
			$aData[$i][2] = $iH - 140 + Random(0, $iH * 0.15) ;y
			$aData[$i][3] = Random(-0.5, 0.5) ;vx
			$aData[$i][4] = 1 ;vy
			$aData[$i][5] = Random(0, UBound($aSmoke) - 1, 1)
		EndIf
	Next
	_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)
	$iFPS += 1
EndFunc

Func CalcFPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS)
	$iFPS = 0
EndFunc

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-07-10

Func _Pipe($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Pipe
	$Pipe &= 'iVBORw0KGgoAAAANSUhEUgAAAQgAAAEcCAYAAAA7sSpyAAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAAB3RJTUUH3wgUADUVD1upDgAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAgAElEQVR42uy9eZRc530ldr/lrbX1hh2NJhorCVAgTUmhbFkSNbalWNaJY8myJ5blJbIoy47G5skZyeNlJiNbJ+ckmcU5znjsSSY5mXEmi07k0cxYliXFY0mkKG4gQQCNxtr7WlX9ann79/3yx6v3uhoUtZAAF/Ddc+qgu7q6utBd3333t90fI6XxUkAMLwuMvt9vuOkHvsyfX+KNDSJ6Tb0OluEF7+yhr7/oU2w/lIrv+Q6P/74gX7EDXqJEieGDzxhj4JyzASlwIhJaa05ETEr5oiSmtc4JgABoAGrwLw3IhG4ij5dxIX+JCuIVR6kgSrzOVcOQQuCDmwAgiEgCMBljNgATgNBaM8bYC5SA1hpEBCEEAVBEFBNRCCDmnOdEcTNp0M1k8b3+LkqCKPGGI4dbI8G/07nh3+69y4ZIwWSADcDB9r81ItQBVDOy2H6S/KUPv2Qi0gBixlgPQAdAD0BERMng/hBABCABkA4Rx45w5LaFGCVKvN7I4ZVUEIyx/JKdhxByoA5cAA2tMco5xgYf13u93ki73R5vt9uNfr9v9ft9TkQsTVMopUBEME0TruvCsiw0GjVlWVbkuq5XqVRatm17UsoAQDAgC29w6wHwAYQ3kQV9LyGIfB39lb+zoihR4rtIaHab3zPbz8+gSIMzzgFwApkMrBInccM0zF1K0T4h2IHrN+b3nTt3buzKlSv1paWlRrPZbERRVOWcm0opbhgGDMMA5xyccwghIKUE5xxSCG0YRmxZVs9xHK9er/dGRkbCPXv2+Hv37vUmJyc36/XqBoAmEZqMoQ2gozV8xhBqrRMhhKYsGQKlFABACLHjd/f6CTFeoOJKgijxauYb9IsQBAcNwgmllRRc2FGUNAzL2A3gYBBGU7Ozs1Of+7/+74PXr1/fs7S01EiSxCUiO45jmzFmOo4j4jhmN4dEhmHANE1IKWFbFlmWpaSUMWMsZIzFABIhROS6bndkZKR98ODB5pvf/Ob1M2fOrDqOtZokapUxti4lbwHoEVFERKlSigzDoPxnaa3BOS8JokRJDLeOIHiRhCSAa9IWZ7wax+m4NOVBAg4/8cSTRz/3uf/3rq9+9asHulvehO/7da2147quNAxDaK2FYRjccRzmOE6hGgBAKYXhcKPd2oSUkoQQ2rIsVavVtG3bmogUgEgIEbiu20uSpD0xMbH53ve+d+Vd73rX4sTE2ByA+SRJVg3DaAPoA4h939eu6xIRIU1TSClLgihRksNLDicGBEEDchgoCEbZJzYRRhjDvpRwuNvtH/ujP/qjY5///Ofvunbt2r4gCEZ0krqWZZlCCKGU4kopNlAKLC9jCiFgWRYqlQoqlQqq1Sqq1Sps24YU2dd936d2uw3f9wkADMMg27a1YRipECKxLCvs9/u9drvdOn78+OrP//zPz73//e+/ZhjimtZ6nohWhRAegDAIAm1ZFnHOt/svXjeNUiVBlHgNEMPN79/hc8AY4wRYAEYBHFLAySeffObUb/zGbxx75umzhwzL3A2gVq/Xrdj3pdaax3HMoijKS5fQWiNNEpiWBaVUlhsYzglwDiklXMfCxMQEJiYmUKvVYFkW4jiG53nwfZ8ajQYppSiOY2UYRqKUCpeXlzuO46w/8MADC//wH/6DK9PT0zOGYVwaKIq2YRiR1lqXBFGiJIdbTxCMMSYJqAGYBPCmL33lrx/4yEc+cmp9df2QMI1x27bdfqdj1EdHRd/zmErT/DuzqofWxefDpCCkRJ5IJK3BOAdnVPREMMawe/du7N+/H7t27UK9XsfVq1dBRJBSktaaer2eSpIkjqKo3+12'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= 'D1euMhhDoRbyvIUz+F7XdUFEiNMUnufB8zxNRPHGxsbWmTNnFn72Z3/2Muf8mtZ6jYh8IaVS+SDW66Sq/oYliLLv4TWuHhhDqlJIIQGAKUVSCFQA7FKKJh9/9KlDzfX2rtWldddrdaXf81kQBEjTdGDtZiKOQ6Rp1s+QlSGHqhcqQRJrMAhwADpNAUNCCD7YmckgeUYumhKkSQrDELBtE5YkMMNEP4phGAJBFOLKtaukSCvPa/txHG78nb/zX80xRtcALDPGPM55TEQ6W9OBYpnO64GVS5R4zSEnhzTVDIBgjFlK0QiAAzdu3Ji6cePGvvX19aKsqZRi+eaq/GqfX+WdweKafNybcw4uRZHELKoUQ1WOnAiHTWvZwHAiX0zjOA4AoNlsQgih+/1+3O12vXe/+93LDz744Jxt20tpmrbTNI0AaMYYaf36+juUIUaJ1+aVa9ucdTBvgQbADnhe9/Czzz57140bN3Y3m003DEORz1rk3zMcNgAoJjmHF+BEUZJ1UbJsHiNRKVKtinAkJxXOOfggVMmViGma4GbWF7G1tYW1tTXyPE+FYegD2Hz44YcXarXaPIANAL5hGCkAynZ88ttqPHurlXGpIEq8NgmCcRCBS8llkqgqgL0AjszMzBx/7rnnJtvt9ojv+6bWmnPOWX7o8kOdezKEYYg89MgTj8WmbiKAs+w2FDrlZc48YZkrk9wsJh/G8n0fy8vL6Pf7OgzDuNlseu95z3uWf/iHf3g+juMVIvKklBEArZSi7Ln4bYsubkfY/KopiDIHUOI75zm2HaoNQ0wAODw/v3ji7NmzR5aXl/f4vu9GUSSIiOVt0UmSbHs1DCZJ883cebJyW1UkO3oibiaI3DFKaw3iHJLxYmjLlAZSrREEAZrNJiVJohhjvmVZm7/+67++AGDeNM0NDCY189AmH+HWmnArRcTtPEtliFHiNQjGlNJCSm5rjVHOMdlue8e+8Y1vHJubmzuQJElda20C4MONTTtyGINkpWma33ZyM3eKipXedk8iCeJsR/UjL3kKIWCaJhzLhpQSfr+PjY0NRFGk+/1+7Hme9zM/8zPLb3rTm+bjOF4xTdPTWkeccy2EoFzhaJ0faHrNk0NJECVek+SQXfC5DWAUwKFOp3fi8ccfP3Hu3LlDvV5vjIhsIhKGYbBsk3amHKSUhedkrgSGySHPQWSSgkMzgN3ktp0jVwu2bcOQHLZt7zCR2dzcxOrqKiVJorrdrl+v1zd/+Zd/eYGI5g3D2CCiIBvl3j7ImcpJYVnGyw4zXikFXhJEidcaOXAAJmMYUYomOWcnZ2dnTz322GNHW62tPQDcJFFSKcWGm57yioQeSP/84+GE5bCfA+O5xRzt6JLMcxUOY+AyUw2WKQtySFQKHSksLS2h1+vpNI3jJEm8t7/97csnTpyYB/QKEXmMsUhKqTFYepO/1lfLjLYkiBK3IQ9At/W5h2U352AAmNYwANQZw36t9YnHHnv83ieeeOruIIgOSinrSikTALMMWYQWliFhiEHTUhwD2hyQAyD5TgUhGGAYEprl/g7byc3hPEWRhxgQDZMCjuNAa43L16+j0+kQAKW19iuVyubDDz+8AGAewEbuTj34nxa5h2wJD3/dqIeSIEq8ahiQApJEgTHGeMYWknNUAIxHcXro/Pnzx55//sLRIAgOVKvVkSRJrCRJuJSySExKKWHbdkEOeT4h37OZk9zN/QycA4lWSBJVlEiHKyG+76Ner8P3fdTqFSRJgpGxMSzMzeHcuXMw3YoGEHc6He9DH/rQyvT09DyAFQCelDIiIo3XuNdDSRAlXrMYWl3HOGccgBlFSVVKOU5EB+fn5w+trKwdIKLd4+Pj9SRJLKWUkFIyx3EQxzFyt6j8ym+aJqrVKoQQ8H2/aKvOV+zluzAAQEoOoQVMMSCPgXGt7/tQSqFWq2G3bSNOs8W+x04dw+zsLB599FEwISiOY50kSWgYRuuDH/zgYq1WWyCiTSIdDBbf'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '55FWFcMuZbdbG3knoURQBpq60Miou10ZPSC1ClKG4uDaFHKp8zzPQHMQ694qauRt9uI8CfdpEIj1MMmH28fNum8SugYjwk9nJoC66wh8Jcsx3NP1lB8GKA8Qji1DjwFk5Hx28+wJySnu+BSuVL/RW6wRoc6JGlRrgf8etr52LdadiMVB/vauhpHUMXsyErbsoKUIzr4PRo/acQ39Rg9y1SgUqyCNgldp7TDriHDidQNFgKTssB9iSCqWJel0crq/fvTo7fXjz16gTC+I6EccmA/3heE30kFY/MB3ScrtZrPZTdNUc842PAVdGMky9n2Bsq/FTAg6cihIfHUZmRJLeA96SJD28cB0GoIf9yj0kUYVJ2bvhjn7JH3ZNWj3N/m+dXzY7eOEVljncGX6ycwRbpuS3FEzSkBfJSzayXigog/KRkSLoebABVLnTrK61V0UYM+2aM3j8wzsoJih+VpPc9/MWOeR6BMzEA++zUepVQhDnOs3/OpDZivcho6uYT4A5fhz4tc4ZqhRuFB9njEGlHcMXCNNXF0JayxuviNdv/YkztTMklCJkHO2zfZ0OTm/ePf0yy9fPvniy29B/ALA++ge7NOt5qc5KvevX0+BGPl4nVOq02Ze0lSah0iSGcaEO4M1g5NDRyy8CghDD1eB7dyT6Ig082OGsUqSOwXRyDzFqZFLlP2Nqri9vUXenkCyoJQZaHsQC6p2vN/fomQcsSIYY3hOhugoQsFogPBI5IywYUmgZquKk0xijaNrAtgwXdEIrYk7fyJnKLSA3fbuUvKRnUlwHobWduB4Rgfh3wLvJBLHjCLKMo+1hspaEcYQ08KVGeuHmJO425Y4hpbs/879IX5tW30Zsd0YsYJemDg6HVe++vUkZkq5QFNCWxYreW7T+fnN+cOHr66fPP3rdHX1F4BfAFiZD592D/fF4ddcIPyaUSF8W0q5ned5n3NuwtnMiwRBCBIy6xZ366GKPGj9fa/OMTmzcIxWchdw7f1w+oUdiaIDUCU0a9jt90jw9WnOE8jU5c/RZcAMGYTGjCUW7CmuCMMzQkwrucqCjA1xLQYfg3FggNFaJJI4scoC+2akQPeVqEhC5gIziuRzAyhDhGAMQBk9hotEcCdrzBZC9+wDEFPwSA6LbiEqjJ/EAcdpEetnMddxaTchmDcx7OX1oR8D36YOkOHI6Oh6t6sgCEiwzk8cgOkFosOAXDRtt8vlw4dvnnzx5VfnDx78CeC/wPAKtAJp7+8WvxEdxBiEK4wXQN+nqfw4b7Zv583Jbtq830pOwnuXIh/nPyi8vdejaZUH+x5CZ8wIzQ6nWe0AcV+zKkCesu0bBz9Zb9uCBEUqXoR6eApMgG7+oCofPn4N92AiWWOcHLAS+obuUm5ujL2ZzzA84sJnA1Gk1Jwp2QNAw+yDxKbqrsgkkOybmFYV4A5Kydsvo8DFcQBeJAJ8jh7OAM+iawQe81qI2LxkrWKyYy4oXCCFJBGmGmzLI/3E4Ep0VY/jiyJnR8VBI9OzMzzbK0RwZD5DUmG0rpbmbS/b7c3Fw+tXnz199jfZnPzFzJ4b4R3H9eLnZg/DQHb/+lUUCDsuEAi90o4Ir0+2Zy+mzfyKc/p86e10M5+ktlRxpVxGKRN0v0MLK7QFPGXKBbzbQ/ctoCg+fOxxWoO9De4A9tqg3dvoLAKmBKUGGGEPxb4tmLpgmiZIksi+dPcnkSEroaKjt44EQ08Z0ySegzGCaWIjwUJuVtrtkXNBj9M/5wyZcoTbVA/qhQHJNRJNO2p3HoaSb2W0NU+Z8uCYFa9n7DMJSQmtRfK5IYaNRyIoEZdcdwOLl2Z/eGMdK4LWG2rvzo4kt8J4p6MQLusP0T+uHIKCmSDhP1EQcsBptVYH6oRseugWWsTtsfhaukU66cnp6XJ6efX2yRdffnvx8PpvIPqGSF6r6d7M/kXe5P/X4nB/RfmfeEhphE6GHYA3nOT5xcXF8zJNv9tsTx/0pc65zGy0I9SOxALh'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= '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'
	$Pipe &= 'P0QYjarYp7AAcqG2IGAEYAJgIt5P67rerRaLvbqup28v3pR1XZeLxWJcVdWobdu0dV3Stq1xztmuqS0RaSJi7z11XYemaYL5TPic2raVtm2Doe5af6GvINaeqyilXJIkjbW20lo3xpjWGFPneT4bj8dXu7u7b3d3dy/G4/F5mmUXYPMGwFsErcptBIUaQLcODKt3hDfo0ffdgdgCwnZ9/AAxPPhwu4wRVtCOOk2QBEBKoBRATsDYi59478ckKNq2nVRVtVPX9bSqqmI+n6fz+Tyvqmrk2mYEIKMwbqW+z+A7R9576r0l6rqWtm2lPwoNVUasHCJoeGNMY62dpWl6a62dHRwcLPM8X47H45vxePwmsfYiAsKleH8dK4UFgApAG4GhB4U4vfyVPgNtAWK7PtIjxn02wf7JC5QAkEMXGpsh9F4pkIkVRhqrjBRAEXkWIwCZ8y6rqqps23ZazWY73vu86zrTdR23bdtb27H3nuJ7I845cc75teMPgKCGMsYgyzKkaerSNK2zLLspy/IyTdMbIlrGqmAGomsANwB6UKgBvQ4KfoDCD9ws3gLEdn2UPYh/9QJ1YU/130QenkSEWaAo2DFpAAaAZWIbP08AZAIZM2QEIAOgvXMUpxkkItSTsZhZlFKeiCT2GFZUatpI0fTifSMiMyK6IeZZPC60sZdQQaQWkRZAJyKeWPdGLh+lQGILENv1UQPEP1red2HUGKnW0bGaYpLWeu+Cvfj+aKLikcKywALQg7fbWnUCgMR7Iub1TSy/UUn1UYRNPDI0zjnHzJ6IfPy34fgQeAzq474wtgCxXb8FEB8rUPSNOnKrcl9oresev+aDY9P6xl8HDhVNlmjdxTUeI0hEqDeyXQeH9yYZ74OERxhJeg7gAu+9xJ+TdSHXL7+t8iv/Sb/+PmwBYrv+owDxsQDFuxuiT8jC2miyt2gbNi+H/d/nYUTqNL3Tz3gvBBgAdV232vi8FhCM1eP+wobqpRHya5usp3Mz/1oFIb8JDFuA2K4Puf4XTTSCw4+RofwAAAAASUVORK5CYII='
	Local $bString = _WinAPI_Base64Decode($Pipe)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Pipe_264x284.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Pipe

Func _Smoke($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke
	$Smoke &= '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'
	$Smoke &= 'aaXobGA2t6q4drDPvcW1i1hSAybB5X+oRuvPuE+AtQx281XCbwPr1sqFlvzt8YQbeJ0D1mBuxSe+Rd7TUoO3SA9aKrBIBEsAp6xU/d8NTCe8MsCFEniAT/OtlQsf7HgrDyZxxQ3c6q2tYwrwb3tPdsqEBswbpAZfzI0nAYaWseD41fyzZjGd5CM7A0d9fLAb/tth/eOw/mqf8wiCzbCWRsp3Vnu9s/ff2fkZbst72do9RPvMZqUjOGkW10wAZbk2L+qdsFdhEY30NrCYdrM7W29sg+9ttRzn1qLWLDfYbriHi93YuRMA7wDmAGu9h/zRItujrYDzZlsZ+6k/Agw30EGYai51Yz9bEvcO+kzF0+xQMxXc7AT+6GyDW3Ortol23SRunVGrvYfL/gfnbewz9gZ2kVQi/AgwSTinQ4X9m21iC9dovPKITUWQNZO2EU9aU4OyUjcliZA7kPUb7KNDqO9EPIvXgHMuj9HkbrAn/B4+30Jiq7QbyS4AZUAe0pK+ezt/PqEYdo5EwQ23zwoAjBn5IlU+uedqYJITXouEU33SPSLBXp5QLy65BYc0S5slMUuSNVM+rfj8Yg/hNwPli7nWPTilyMOdZR9XheseT6tCrRttI6PdCJO/RnotUmyQ+W4BcgAPtRxmQqhOALCH+43YVESWHGFhG1gQQ3SHa41IDcqlwCRYQcJTITBtI9o16PA0Own1vRSGA8LwHW40CWgRYLcN7eEeM6yNOdcONVhCVNX7yJ8/f65OS6X2J7hF65AFAE0gaZYESfKOFlZ3KDyzYx0bbK6TzLvYhlt68Ih72EsySIvawlIGuLoqicUR61c5JknbY8FFVdTm5rbIe7Ywbd4kw/UCgOuZhl+Pzx4hp0YpPmcAs0VHo3N4sa5kyKuulHCMUsDk6LYR5norrsPek/IRuWt2gIkneludJJs9wJklmrFEyFKxF3Gtei5crxVeSTJSPb9DlkpgRwnB5A+tqpkmVGngVQF4h/cXcA5/n8CPs0Q3bw//+5sCU/B0q9MZoJzZgXCzuEgS2YCyAOumHkBlAb+BOkmILUKqCfVYA6siAt2j3FguLSg9YGb5e49q+B1atJ3Ins3vt2JVvUQurd43MOsgxLvY+2Z54gvSA+ZYAaAe7+V3Ww9CAVVArpcAoz3nDjXSLToDau5ZOgBBKvRBqma+OilDgmhBrJua1DABsDF82y8vkF6ZcHZOUHkG1CGEx/4CfolOaOW0Q3RWOKHznBK110TvXjjAq4WC5GBVomaBa8YVreZkuF6rtqvwAlPzHlahmq5H5NHpQpySHzW/ik4oZ+OvQ+4zi548OKXON/fXErx4ApSMzDJJMUifVs3XA/fUhrXHdEqO5PFGtgWcxIJ3h2MtlPcSycoRiDWO0dK+k/RZrUUnGLy/X9osi06jzVPb1FWjZLazI5Ns4WqDk1VHD5TggLGBvnqHJlly9JHg+KlnAdGRD05xzBpnMYfqVnKqJML8rQhnUe6pOxBttxaumTgNiD4bXHgnLhKl4IwrFrCWEF5CunHF7XrIEQGhm3VaQqfi6wpPPtVnB3CeugrNgnph7wE5yw1cbYsuYicmPEheo2beXysrOgBWR6zvkW1T74molTbgkgVdDdWdRkgfT8BoN4D5yoAPu0PTixX0RsBJctEU/ElPdbe1AHDK/ejCjJZFxPxe6KKX/ChI2H/axCAbTY7pqsjNandwfDhKspUdQNZGzOrKsShZcZbELkhQSHjgGyyK+vSCo1vFIB0AVqiT8MeCLPPWyR4j6qUkHcuM0n+LcK8AxTPhOkodpcAueAgjxLQBEkR2il7VtcsBHBeUUSraQeqnHaSFIAUczXErtVQWBY8WdemwtFqiSiXtWns0+4pU/dEZWwnS1Sjak85S98xwowXic0IRR5fjaNkbKHdF8p0opHxp63QRkLXg3NvxCR2IKTwfcVMXjOgqpCAsXmFqMwq2AaEtS57yRgic+ke2anyHumbGZw4nAPDql4IQ'
	$Smoke &= 'PMmmBpAqLecBVf8kquHiqJFPFqnmX50Kuyn2Bcg3QegDphCW8Hwoun3OrRRuizT2gmi3iyM5ZhG/q+N+cUXPGUVvnqUrmqVmqj1S6cWRMr1Jyxlq/fGJfERfp4j0wGp8A7dapLirTu+qyvHlRMvD6xjswrfD2VWCyOR0HYoCU0GmNF+9mdaM34uJBpt00AFoDkYnJGUTSNELv0U2XVYmpZr7P4pS18if4XsvAWYvPa1n0uYSzs/2V9xEy2UyOKnlB+/wt4CnsoVFMawmp7YqDlFmRx6o2OQDRKlR7uvOrvVVit9Z3OuZHlMQdr35OCU/ned9tGmDW/SRiliAkt65grHixkcBhtyjTUC1uCh5Wrfivk+cxVpJSTc5WkqVC1UUcm1i/HdEIW8WheQdHbFKM2XmIrTYLD2kSTJrLwtepMOg4FSVH3onj1hOpOccgOaTG81U/2WAvV3JnKNTbKpuvEjYD9IqnoWMF0+Fk/1kmXjgdespoSoEf6a2npA7m5k383wwl9qimU+yi3BFLQa9oSKtqIuzSbXyZaUdxG/JXNRG6a+oatU8OXg4SH9pkn5ydQg3iiVkuelwgnfKyr1Gue4Y/j/I2Aj6ESG6Xjs4dO7V3KeF3BsA1EkhyjxkEvkxSCguQrCay4zYkDcpXpEdPxgg9wZOm535KpnwTwWmrph2D3KeUYPV8O2oaicyRXCq3EnWDKuqYh1BmvsPAKINLjZQHhzL/GnAcFBnI1IAXSo4zbnkkLCO5zeSvccTnuF2QUoTFpQZwDzAyjj7lxGefyowSfrZG2S0e1hNxgyLithJROwgVrhHGvAoUTCAVCdU+ZwFvAcoHH7Kl1Tzl35fySvWtCuZkf7X8Hy8TGXPTmqzIpLCAqvZUxLAJvdCxgssQ2ugq76Qeuk33OJKOOcQQBX5YusI4Tp5XoRDNBnTuRYdIhhl4wzNs2TbV30h7BpgApg/ApQoHcsKGbMTS4nSeM+OXlJQ1FLgZkQkmEVcMAf/O05Xva75pr6XV2RxLR10VjG9k7wliwzAp9+LyB4dl1tE6likoRbCd3536RpgtL4pIoZHsaAkXLSVUK5PW/WYRXjFy2uqkzK86DfczvV1VN3naJc3uMgBxYiNRAnfi4T8tf9MQ7PwLNYSwg98JeeacF2d3o6n3WhIZTt0L+bNbmUnve/sRJQano/yU1tZVjoJ32VF1+Qx1SkLgjwlryMwoHTQBHEA0epEFVs51WmVeFW5x4P1pThmDaByZn6litt14mJVkjpvIMgbSS3SH1qcbuSLc8wlrhXOSBSLlAIs+NomZ2n9tt44BfnsdCjrGS3mDwfmmiZZcXiHWa9OMATpOyXJe2rwR9nCawHmWhDrSr+a7qNApfD8e0vlOx/QqwQmrOjIGuEa4dbwfNQthD/wfwj5rwADALbarTBo0D+hAAAAAElFTkSuQmCC'
	Local $bString = _WinAPI_Base64Decode($Smoke)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke

Func _Smoke2($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke2
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= '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'
	$Smoke2 &= 'TTussiCxD0c8JaPNJ+cRoi0RubZTJ6xW6ybsvjYMN0lWa8KuKr6I2pmcR0X6HNgUirVSMdYkVE9AcJ43mvxjVdRcpYmitdst/K8M1uwntzkCWjn500zGwhbXNS6jrZh27Mjfx1pub8KvzjTOoYuLl0RozcpFIjIRUYJDiytXj2cPn7nrkYjt95xa7dZwUz+++kMJblx6ysC41WOrEn7muVX933itvjnhpsw1AcGt6vyMRZqcrpogSSASioz0nvSWgB9HjrejjjRWb+QC2JSUgQitfkdqb4ztggdBtYa8lTzamkVfZOT7ccDnzsQrasNfHQ59OhD6/WlYTfEX1ymVjsxj2DgG3Hrg1S5hqcYamsjN8Doze2qTa1ZvHhA7QxGRoZoUt/tkwy/0Ft2OAn45M+9fHDafJdW3WPMpatc83zXOmtvkZZ9jijmGoZoU15xMmMOuKWkOEM2dzQ6hzJwzM/rU//5OPdnOL68JrC6+/tQp2l0D5pyCmY2S3zw7tyvVdcKT5qWPsk+XcLLTyBqOmIB6NhBPMlwjxb1B+rNq3H3sW79xktZfvd2ad7zAV09F0++fMmyQ7qHS1agPqQ57agU/tymK1dzXLz7r4CU72TSxpk76jX399en8eXIEf8E4fP5chtsRV0yVjQR5FZK/+1EN949G0OeJk3/OgfTXwDyX8Re8566x3u7Grsyq749afbX0T3/qdwzyDxvm5kX2Z4yyzWJ/V7Z/7WP8LlQ+DSE9H0j/jUPof8kwmyqHTJUoo6UL3oN6X9n+h3QbAPo08fDVnf4pB/nnfLbMv+Sjfl7tEncQN+xi7qdPGtlfS/76U2j+1R+y8y/7+qsfufT8uv+Jj276b4cQSoTLd9SzAAAAAElFTkSuQmCC'
	Local $bString = _WinAPI_Base64Decode($Smoke2)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke6_70x70.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke2

Func _Smoke3($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Smoke3
	$Smoke3 &= 'iVBORw0KGgoAAAANSUhEUgAAAEYAAABGCAYAAABxLuKEAAAX4UlEQVR42tWc6W8cR3rGp3u65+J9SNRhy1pkHSfYrAMs8jX/fz4G2AA5sJG9tg5SJjlDcu6jO8+v+BRRO6YsUrIcm0BjZrq7uup96j2e961qFo1f+K+u60x/9V3v1QdHfdc2P9df8YlByOPX+wqmti19NP0z0++lnjH/zQOTznZ6/i4AqS2AtHV03b7Ssayv1W3xmwUm0ZQ7g7EGSsdH21qz1DEzOJXBAvTqU5nYJwFGg60MzocMPIsY+VgZIMaa+/p0XRN/M6YEOB/okGm3MAiNRGviUeq4sAbVa36s+tUDc0cfFB1sV7/RjKGEW/r7zObU9X2FTWrbx0DHODErHPSKQ89YGeD4/bcDjGe+p2NHxwML+L0EO7egGzoOfG3fWnSlY89tT3S8NrAtg5hZa4Y+rvS88YeAU/ycGnCbP4nn+VytVp1msxn73bLQzyzsyObDDXOfOzIom762bzCjv6kNIL93fa40gG90/NWA/rLAJCEZYXKk92CbVmWurewHesPh8KuqqtqtVmu2sbEBMI/sQ3IfT9x2ZAG7uj/L83xu84l+JjMQvdi3ASp9rZc8o7gPqfwoYAxInrRv+4igtLgHoaQhS/sJgPj7y8vLP2iQVwLnbVmWhbVj4baHvncyn8+bx8fH/zibzR53Op3L/f39U4E59OyXiRblSbTKPSENP4d7zn9JH5PbruNs9zxjCNeSMAcC4PFisehKmNc7O7iRRq/b7e4OBoNtXT+cTCZLATOwQ10sl8tCf3zfkMltvnjx4l+vrq7+SeB2dV9/NBp98+TJkz9vb2+fcS++RKBHrcySKJYlptVLzn8aYGwOdQJMZKe9JHp0Nejtt2/f/osEP4LWC6BMYAyePn36FwncxBFKA4ZW7bmBaQiAWm1DCH758uXXgMI9En7MM/X7az3mSma1ELCFQB73er1hoi3RxFrWKiJWnz5SM7Ic2fsccnEPsykTVa3cNhIvjo4E2Ov3+7+TAH/S4J9JqBntZRbnm5ubZ5r1vel02tX3E2nSmU1opHPbp6enzwXmA7RFmranz7kA7GOK+v1QwJV65g4SSbMupUVDh/TS4Ab/ozHMdS9+7a1AnOjexRqrbvn7AmrwMRoTQSmTSBCBic6wdX5+DiB/HI/HX0qAz+2MlzGECrDPNOCmBjvQ50gCTCTcUvc3de2BHPNzAfCAXIhBAxgCSrC52ox04ERztesKsBO1vfB4VmbCmQDuSbNamggpVLfU0dN9mbWkSAiisQmcp/5QYLI159ZIKDt/CFdIuH/WjH+lgW9oMCcSJEYjzAGteKLzP/BdAi/Pzs72JeBEgOwJyCfcLxDOJdQGZoXA+o5gc7UZYk56/p7M7E9y3Ae7u7v/dXBw8J3ALHUtxz/pelP97KjNVL+DA5bmbah917KOkpRj+VOR6q4+JgUnmhIzNWEGBMwDgbDLIFBPZlP2/z2gIJwGNtfgN3V9WwMHuFN9n8q0AqMlHKv9SPcN1P4Ak5TAmA3tFgLwSmD19H1fwn/ebreJXpXOv+X5urcQWFd63hHayrPUtqHvuzLZHY2lZVBOPO7g3zCtd/ma4h5RqEhAiSDNNZgDCfkYE5CAMx1jJ4+zra2tV/gOAbep80sJvtLR1gGjnWpgbd0HSJnu2TaALUetZ4R0fb8UEFfSgKHAAfi5gNgSIICHmczUvqv2ezoI7890DAFMfT7RPfsyqW9wTQ4SlX1SkZjiB5tSSqxuzEizv6VB/FGdP4HbSbDLkNXl+RTHJ0GICAg1h4+g4jpmur8jwQEzOFg1kRxztK5AYKt/pc9d/RZWy1eYk4Aa62jq3EP1vS8z3FUfhfzKV/Ak9blN9+rrEWBBB+hb31/rc5bkZpdxsl3GaKxXAoo7hOgIyCoBpkQIacsfmFkLU+rBIcJo8HASBOmLw/QlAMAd6twUQaRFX+nclwxEs/lI5/Wo0e+DagpU'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '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'
	$Smoke3 &= '1jQ4uYnjzUrFp3xb/qNfSI8JWAJQtfamSprRVgajEU3gFoZdOTTPkuRwmTz3F/kHOz/bm/rpDKYoJbP/oxrIT9h/baY69gsd06T2XLmL7D7h9/8NmJ8A6W/epbyLINaaRVITmiYalP7/mHSPbvWrB+YWrfiQ/8ixNI2frhWa6hSY+4bhXw0wH6N1pvZp/TnVjE/qa/4PQ6vcVo9IyLgAAAAASUVORK5CYII='
	Local $bString = _WinAPI_Base64Decode($Smoke3)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Smoke3_70x70.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Smoke3

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode